﻿using System;
using System.Threading;
using System.Threading.Tasks;

namespace VBECS.Services.Common.AppServices
{
    /// <summary>
    /// This class adds opportunity to call synchronous working processes in asynchronous manner by utilizing TPL.
    /// </summary>
    public abstract class ServerProcessBaseAsync : ServerProcessBase
    {
        readonly CancellationTokenSource _tokenSource = new CancellationTokenSource();
        Task _task;

        // Derived classes shouldn't override this method
        protected override void do_start()
        {
 	        // Run worker process in the separate thread
            //Task.Run(() => do_start(_tokenSource.Token), _tokenSource.Token);
            _task = Task.Factory.StartNew(() => do_start(_tokenSource.Token), _tokenSource.Token);
        }

        protected abstract void do_start(CancellationToken token);


        #region Disposing

        private bool _disposed; // to detect redundant calls

        override protected void Dispose(bool disposing)
        {
            if (!_disposed)
            {
                if (disposing)
                {
                    _tokenSource.Cancel();
                    //wait before task stops
                    if (_task != null)
                    {
                        try { _task.Wait(); }
                        catch (AggregateException ex)
                        {
                            // Any other exception besides OperationCanceledException will be re-throwed in new AggregateException
                            // http://www.blackwasp.co.uk/WithoutCancellations.aspx
                            ex.Handle(e => e is OperationCanceledException);
                        }
                        _task.Dispose();
                        _task = null;
                    }
                }

                // shared cleanup logic
                _disposed = true;
            }

            base.Dispose(disposing);
        }
        
        #endregion
    }
}
